from visual import *
from random import random
import time,sys,thread

class VisualSphere:
    nSpinsX = 2
    nSpinsY = 3

    dx = 1.0
    dy = 1.0

    visualArray = []

    def __init__(self, nSpinsX, nSpinsY):
        self.nSpinsX = nSpinsX
        self.nSpinsY = nSpinsY
        
        visualArray = [ None ] * nSpinsX                               # a vector of null elements, nSpinsX long
        for x in range(nSpinsX):
            visualArray[x] = [0] * nSpinsY                             # a vector of zeros nSpinsY long
            for y in range(nSpinsY):
                visualArray[x][y] = frame()
                visualArray[x][y].point = sphere(visible=0)     # red is an up spin, blue is a down spin
                visualArray[x][y].tracer = arrow(visible=0)
                visualArray[x][y].line = curve()
                visualArray[x][y].circle = curve()
               
        self.visualArray = visualArray


    def addPoints(self,numericArray):
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY):
                self.visualArray[x][y].point = sphere(pos=(0.0,0.0,0.0), color=(1-((x+y)%2),.3*(x+y+2)/((x+1)*(y+1)),((x+y)%2)), radius = 0.02)

    def updatePoints(self,numericArray):
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY):
                self.visualArray[x][y].point.pos = numericArray[x][y].spin


    def addVectors(self,numericArray):
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY):
                self.visualArray[x][y].vector = arrow(pos=(0.0,0.0,0.0), axis=numericArray[x][y].spin, color=(1-((x+y)%2),.3*(x+y+2.0)/((x+1.0)*(y+1.0)),((x+y)%2)), shaftwidth=0.002)

    def updateVectors(self,numericArray):
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY):
                self.visualArray[x][y].vector.axis = numericArray[x][y].spin
                

    def addTracers(self,numericArray):
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY):
                self.visualArray[x][y].tracer = curve(color=(1-((x+y)%2),.3*(x+y+2.0)/((x+1.0)*(y+1.0)),((x+y)%2)))

    def updateTracers(self,numericArray):
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY):
                self.visualArray[x][y].tracer.append(pos=numericArray[x][y].spin)


    def addCircles(self,numericArray):
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY):
                self.visualArray[x][y].circle = curve(x=.1*cos(arange(0,2*pi,.31)), y=.1*sin(arange(0,2*pi,.31)),z=.5, color=(.6,.6,.6), visible=0)
        

                
    def resetVisuals(self):
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY):
                self.visualArray[x][y].point.visible = 0
                self.visualArray[x][y].tracer.visible = 0
                self.visualArray[x][y].vector.visible = 0
                self.visualArray[x][y].circle.visible = 0 


    def getArray(self):                         # handy, since we dont want to have to know the name of the object's actual variable!
        return self.visualArray

    
